function [var3,sgn1]=illustrate(data)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 12.2
% File: illustrate.m
% Coded by: Dawit Zerom
%
% THIS FUNCTION COMPUTES EXTREME QUANTILE FORECASTS
% FOR A BIVARIATE TIME SERIES.  MARKOV COEFFICIENT = 1
% NOTE:  WE ARE DOING A ROLLING FORECAST nrol = 498 TIMES 
%        USING A SAMPLE OF nr = 800 OBSERVATIONS.
%
% INPUT:   data = THIS IS A BIVARIATE TIME SERIES (here,
%                 ExchangeRates.dat with ncol = 2 ("DEM/USD"
                  and "DEM/GBP") and nrow = 1300 observations)
% OUTPUT:  var3 = the accuracy measure - the empirical alpha
%          sgn1 =  p-value
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nrow = length(data);
p0   = [0.01 0.025 0.05 0.95 0.975 0.99]; % the 6 tail quantiles
var3 = [];
sgn1 = [];
nrol = 498;                     % number of rolling forecasts 
nr   = nrow-nrol-2;

for i=1:6;
  pcon = p0(i);
  sdev = sqrt((pcon*(1-pcon))/nrol);  
  for j=1:nrol;     
    W = data(j:nr+(j-1),:);     % length of in-sample data nr = 800     
    for k=1:3;                  % the forecast-step length
      Y   = W(1+k:nr,:);
      X   = W(1:nr-k,:);
      x   = Y(nr-k,:);    
      act = data(nr+j-1+k,:)';  % actual values
      
      medianms1 = medm(Y,X,x,pcon);    
      medianss1 = meds(Y,X,x,pcon); 
        
      % implied probability loss
      alphms1(j,k) =  (act(1) < medianms1(1)); % return 1
      alphms2(j,k) =  (act(2) < medianms1(2)); % return 2
      alphss1(j,k) =  (act(1) < medianss1(1));
      alphss2(j,k) =  (act(2) < medianss1(2));      
    end  % end loop for k   
  end
  finalms1(i,:) = sum(alphms1)/nrol;
  finalms2(i,:) = sum(alphms2)/nrol;
  finalss1(i,:) = sum(alphss1)/nrol;
  finalss2(i,:) = sum(alphss2)/nrol;

  var1(i,:) = [finalms1(i,:) finalms2(i,:)];
  var2(i,:) = [finalss1(i,:) finalss2(i,:)];     
  var       = [var1(i,:);var2(i,:)];
  sgn       = (abs((var - pcon)/sdev)>1.96);
    
  var3      = [var3;var];   
  sgn1      = [sgn1;sgn];    
  disp(i);
end  % end loop for i
 
%*********************************************************************
function medianss1 = meds(Y,X,x,pcon)
if pcon==0.01;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05 0.04 0.03 0.02 0.01];
end

if pcon==0.025;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05 0.04 0.03 0.025];
end

if pcon==0.05;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05];
end

if pcon==0.95;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95];
end

if pcon==0.975;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 0.96 0.97 0.975];
end

if pcon==0.99;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 0.96 0.97 0.98 0.99];
end  

Y1 = Y;
X1 = X;
x1 = x;

for j=1:2;
  Y = Y1(:,j);
  X = X1(:,j);
  x = x1(j);
     
  [ns,~]    = size(Y);
  h         = 1.06*std(Y)*ns^(-1/5);   
  [nr,nc]   = size(X);
  [n01,n02] = size(x);
    if ((n01==1)&&(n02==1));
      XX = ((X-x)/h).^2; 
    else
      XX = ((X-vec2mat(x,nr))/h).^2;   
    end
    XX1 = cumsum(XX,2);
    A   = (1/h)*exp(-XX1(:,nc)/2)/(2*pi)^(1/2);             
    if sum(A)==0;
      A2 = 1e-30;
    else
      A2 = sum(A);
    end    
    mean1  = sum(Y.* A)/A2;
    medd1  = mean1; 
    [~,mp] = size(pp);

  for c = 1:mp;
     p  = pp(c);   
     h1 = h*((p*(1-p))^(1/5)/(pdf('norm',norminv(p,0,1),0,1))^(2/5));
 
     [nr,nc]   = size(X);
     [n01,n02] = size(x);
     if ((n01==1) && (n02==1));
        XX = ((X-x)/h1 ).^2; 
     else
        XX = ((X - vec2mat(x,nr))/h1).^2;   
     end
     
     XX1   = cumsum(XX,2);
     A     = (1/h1)*exp(-XX1(:,nc)/2)/(2*pi)^(1/2);              
     KK    = A;  
  
     YY    = Y - medd1 ;
     YY1   = ((YY>=0)&(YY<1e-1))*1e-1+((YY<0)&(YY>-1e-1))*-1e-1+(abs(YY)>=1e-1).* YY;
     Wt1   = (YY > 0).*p+(YY< 0).*(p-1); 
     nwt   = Wt1./YY1;
     Wt    = nwt.* KK;
     toler = 1000;
     int   = mean(abs(Y - medd1));
  
     while toler > 1e-3*int;
        knew = Wt;
        if sum(knew)==0;
          k1 = 1e-10;
        else
          k1 = sum(knew);
        end;
        med10 = sum(Y.*knew)/k1;
        toler = abs(med10-medd1);      
        medd1 = med10;  
        YY    = Y - medd1;
        YY1   = ((YY>=0)&(YY<1e-1))*1e-1+((YY<0)&(YY>-1e-1))*-1e-1+(abs(YY)>=1e-1).*YY;
        Wt1   = (YY>0).*p+(YY<0).*(p-1); 
        nwt   = Wt1./YY1;
        Wt    = nwt.* KK;      
    end  
  end                       % end loop for c
  medianss1(1,j) = medd1;   % alpha=0.05
end                         % end loop for j
    
%*******************************************************
%  MULTI-HORIZON PREDICTION OPTION
%*******************************************************
function medianms1 = medm(Y,X,x,pcon) 
if pcon==0.01;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05 0.04 0.03 0.02 0.01];
end

if pcon==0.025;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05 0.04 0.03 0.025];
end

if pcon==0.05;
  pp = [0.5 0.45 0.4 0.35 0.3 0.25 0.2 0.15 0.1 0.05];
end

if pcon==0.95;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95];
end

if pcon==0.975;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 0.96 0.97 0.975];
end

if pcon==0.99;
  pp = [0.5 0.55 0.6 0.65 0.7 0.75 0.8 0.85 0.9 0.95 0.96 0.97 0.98 0.99];
end

for j = 1:2;
   Y0 = Y(:,j);
   X0 = X(:,j);
   x1 = x(j);
   ns        = length(Y0);
   h         = 1.06 * std(Y0)*ns^(-1/5);  
   [nr,nc]   = size(X0);
   [n01,n02] = size(x1);
   if((n01==1) && (n02==1));
     XX = ((X0-x1)/h ).^2; 
   else
     XX = ((X0 - vec2mat(x1,nr))/h).^2;   
   end
   XX1 = cumsum(XX,2);
   A1  = exp(-XX1(:,nc)/2)/(2*pi)^(1/2);             
   if sum(A1)==0;
      A2 = 1e-30;
   else
      A2 = sum(A1);
   end
   mean1(1,j) = sum(Y0.*A1)/A2;
end   % end loop for j
 
med2      = mean1;     % the initial value for the median 
[nnr,nnc] = size(Y);  
[n5,n6]   = size(X);       
h         = 1.06*std(Y)*ns^(-1/5);     
[~,mp]    = size(pp);
  
for c = 1:mp;        
   p     = pp(c);
   h1    = h*((p*(1-p))^(1/(nnc+4))/(pdf('norm',norminv(p,0,1),0,1))^(2/(nnc+4)));
   XX    = (X - vec2mat(x,n5))./vec2mat(h1,n5);   
   XX1   = cumsum(XX.^2,2);
   A     = (1/(h1(1)*h1(2)))*exp(-XX1(:,n6)/2)/(2*pi)^(n6/2); 
   KK    = A;                
   YY    = Y - vec2mat(med2,nnr);
   YY    = ((YY>=0)&(YY<1e-4))*1e-4+((YY<0)&(YY>-1e-4))*-1e-4+(abs(YY)>=1e-4).*YY;
   C     = (YY > 0).*p+(YY<0).*(p-1);
   YY1   = C.^2.*YY.^2;
   YY1   = sqrt(cumsum(YY1,2));
   YY1   = YY1(:,nnc); 
   nwt   = C.^2./ vec2mat(YY1,nnc);
   Wt    = nwt.* vec2mat(KK,nnc);
   toler = 1000;
   int   = norm(Y-vec2mat(med2,nnr));
  
   while toler > 1e-3*int;
      knew  = Wt;
      k1    = sum(knew);
      k1    = (k1==0)*1e-10 + (k1~=0).*k1;
      med20 = sum(Y.* knew)./ k1;
      toler = norm(med20-med2);
    
      med2  = med20;
      YY    = Y - vec2mat(med2,nnr);
      YY=((YY>=0)&(YY<1e-4))*1e-4+((YY<0)&(YY>-1e-4))*-1e-4+(abs(YY)>=1e-4).*YY;
      C     = (YY > 0).*p + (YY<0).*(p-1);
      YY1   = YY.^2 .* C.^2;
      YY1   = sqrt(cumsum(YY1,2));
      YY1   = YY1(:,nnc);
      nwt   = C.^2 ./ vec2mat(YY1,nnc);
      Wt    = nwt .* vec2mat(KK,nnc);    
  end  % while 
end    % end loop for c

medianms1 = med2;

